﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApplication1
{
    public class Program
    {
        public static void Main(string[] args)
        {
            if (args.Length == 0)
            {
                Console.WriteLine("パラメータを指定してください。");
                return;
            }

            if (File.Exists(args[0]) == false)
            {
                Console.WriteLine("ファイル {0} は存在しません。", args[0]);
                return;
            }

            if (new FileInfo(args[0]).Length < 128)
            {
                Console.WriteLine("ファイルサイズは 128 バイト以上必要です。");
                return;
            }

            byte[] id3tag = new byte[128];
            using (FileStream fs = new FileStream(args[0], FileMode.Open, FileAccess.Read))
            {
                using (BinaryReader br = new BinaryReader(fs))
                {
                    fs.Seek(-128, SeekOrigin.End);
                    id3tag = br.ReadBytes(128);
                }
            }

            // 先頭3bytesが 0x54 0x41 0x47 (TAG) でなければID3ヘッダは存在しない
            if (id3tag[0] != 0x54 || id3tag[1] != 0x41 || id3tag[2] != 0x47)
            {
                Console.WriteLine("ID3タグが存在しません");
                return;
            }

            // コメントとトラック番号
            string comment = string.Empty;
            int? trackNumber = null;
            if (id3tag[125] == 0x00 && id3tag[126] != 0x00)
            {
                // 125 番目が 0x00 で、なおかつ 126 番目が 0x00 以外の場合は 126 番目がトラック番号
                trackNumber = (int)id3tag[126];
                comment = GetSJISString(id3tag, 97, 28);
            }
            else
            {
                trackNumber = null;
                comment = GetSJISString(id3tag, 97, 30);
            }

            // ジャンル設定
            Dictionary<int, string> genreList = new Dictionary<int, string>(){
                {0, "Blues" },
                {1, "Classic Rock" },
                {2, "Country" },
                {3, "Dance" },
                {4, "Disco" },
                {5, "Funk" },
                {6, "Grunge" },
                {7, "Hip-Hop" },
                {8, "Jazz" },
                {9, "Metal" },
                {10, "New Age" },
                {11, "Oldies" },
                {12, "Other" },
                {13, "Pop" },
                {14, "R&B" },
                {15, "Rap" },
                {16, "Reggae" },
                {17, "Rock" },
                {18, "Techno" },
                {19, "Industrial" },
                {20, "Alternative" },
                {21, "Ska" },
                {22, "Death Metal" },
                {23, "Pranks" },
                {24, "Soundtrack" },
                {25, "Euro-Techno" },
                {26, "Ambient" },
                {27, "Trip-Hop" },
                {28, "Vocal" },
                {29, "Jazz+Funk" },
                {30, "Fusion" },
                {31, "Trance" },
                {32, "Classical" },
                {33, "Instrumental" },
                {34, "Acid" },
                {35, "House" },
                {36, "Game" },
                {37, "Sound Clip" },
                {38, "Gospel" },
                {39, "Noise" },
                {40, "AlternRock" },
                {41, "Bass" },
                {42, "Soul" },
                {43, "Punk" },
                {44, "Space" },
                {45, "Meditative" },
                {46, "Instrumental Pop" },
                {47, "Instrumental Rock" },
                {48, "Ethnic" },
                {49, "Gothic" },
                {50, "Darkwave" },
                {51, "Techno-Industrial" },
                {52, "Electronic" },
                {53, "Pop-Folk" },
                {54, "Eurodance" },
                {55, "Dream" },
                {56, "Southern Rock" },
                {57, "Comedy" },
                {58, "Cult" },
                {59, "Gangsta" },
                {60, "Top 40" },
                {61, "Christian Rap" },
                {62, "Pop/Funk" },
                {63, "Jungle" },
                {64, "Native American" },
                {65, "Cabaret" },
                {66, "New Wave" },
                {67, "Psychadelic" },
                {68, "Rave" },
                {69, "Showtunes" },
                {70, "Trailer" },
                {71, "Lo-Fi" },
                {72, "Tribal" },
                {73, "Acid Punk" },
                {74, "Acid Jazz" },
                {75, "Polka" },
                {76, "Retro" },
                {77, "Musical" },
                {78, "Rock & Roll" },
                {79, "Hard Rock" },
                {80, "Folk" },
                {81, "Folk-Rock" },
                {82, "National Folk" },
                {83, "Swing" },
                {84, "Fast Fusion" },
                {85, "Bebob" },
                {86, "Latin" },
                {87, "Revival" },
                {88, "Celtic" },
                {89, "Bluegrass" },
                {90, "Avantgarde" },
                {91, "Gothic Rock" },
                {92, "Progressive Rock" },
                {93, "Psychedelic Rock" },
                {94, "Symphonic Rock" },
                {95, "Slow Rock" },
                {96, "Big Band" },
                {97, "Chorus" },
                {98, "Easy Listening" },
                {99, "Acoustic" },
                {103, "Opera" },
                {104, "Chamber Music" },
                {105, "Sonata" },
                {106, "Symphony" },
                {107, "Booty Bass" },
                {108, "Primus" },
                {109, "Porn Groove" },
                {110, "Satire" },
                {111, "Slow Jam" },
                {112, "Club" },
                {113, "Tango" },
                {114, "Samba" },
                {115, "Folklore" },
                {116, "Ballad" },
                {117, "Power Ballad" },
                {118, "Rhythmic Soul" },
                {119, "Freestyle" },
                {120, "Duet" },
                {121, "Punk Rock" },
                {122, "Drum Solo" },
                {100, "Humour" },
                {101, "Speech" },
                {102, "Chanson" },
                {123, "A capella" },
                {124, "Euro-House" },
                {125, "Dance Hall" },
                {126, "Goa" },
                {127, "Dram & Bass" },
                {128, "Club-House" },
                {129, "Hardcore" },
                {130, "Terror" },
                {131, "Indie" },
                {132, "BritPop" },
                {133, "Negerpunk" },
                {134, "Polsk Punk" },
                {135, "Beat" },
                {136, "Chiristian Gangsta Rap" },
                {137, "Heavy Metal" },
                {138, "Black Metal" },
                {139, "Crossover" },
                {140, "Contemporary Christian" },
                {141, "Christian Rock" },
                {142, "Merengue" },
                {143, "Salsa" },
                {144, "Thrash Metal" },
                {145, "Anime" },
                {146, "JPop" },
                {147, "Synthpop" },
                {248, "Heavy Rock" },
                {249, "Doom Rock" },
                {250, "J-POP" },
                {251, "Seiyu" },
                {252, "Tecno Ambient" },
                {253, "Moemoe" },
                {254, "Tokusatsu" },
                {255, "Anime(J)" }
            };

            // ジャンル
            int genreCode = (int)id3tag[127];
            string genreString = "不明";
            if (genreList.ContainsKey(genreCode) == true)
            {
                genreString = string.Format("{0}", genreList[genreCode]);
            }

            Console.WriteLine("ID3ヘッダ      ： \"{0}\"", GetSJISString(id3tag, 0, 3));
            Console.WriteLine("曲名           ： \"{0}\"", GetSJISString(id3tag, 3, 30));
            Console.WriteLine("アーティスト名 ： \"{0}\"", GetSJISString(id3tag, 33, 30));
            Console.WriteLine("アルバム名     ： \"{0}\"", GetSJISString(id3tag, 63, 30));
            Console.WriteLine("日付           ： \"{0}\"", GetSJISString(id3tag, 93, 4));
            Console.WriteLine("コメント       ： \"{0}\"", comment);
            if (trackNumber.HasValue == true)
            {
                Console.WriteLine("トラック番号   ： {0}", trackNumber.Value);
            }
            Console.WriteLine("ジャンル       ： {0} (0x{1:X02})", genreString, genreCode);
        }

        /// <summary>
        /// バイト列の指定オフセットから指定バイト数を取得してシフトJIS文字列として返します。
        /// </summary>
        /// <param name="buffer">バイト配列</param>
        /// <param name="offset">オフセット</param>
        /// <param name="length">バイト数</param>
        /// <returns>シフトJISに変換した文字列</returns>
        private static string GetSJISString(byte[] buffer, int offset, int length)
        {
            List<byte> b = new List<byte>();
            for (int index = 0; index < length; index++)
            {
                if (buffer[offset + index] == 0x00)
                {
                    break;
                }
                b.Add(buffer[offset + index]);
            }

            return Encoding.GetEncoding("Shift_JIS").GetString(b.ToArray());
        }
    }
}
